@echo off
setlocal enabledelayedexpansion

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Install FMOSLLM Dependencies
::
:: Copyright: © 2015-2025 Claris International Inc. All rights reserved.
::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

REM Automate Miniconda installation
REM setup_Miniforge.bat
set MINIFORGE_DIR=%ProgramData%\FileMaker\Open_Source_LLM\server\miniforge3
set LOGS_FILE=%MINIFORGE_DIR%\..\fm_LLMOS_Setup.log

set ENV_NAME=fmosllm
set ENV_DIR=%MINIFORGE_DIR%\envs\%ENV_NAME%

echo "*** Configuration:"
echo "  Miniforge directory:    %MINIFORGE_DIR%"
echo "  Environment directory:  %ENV_DIR%"
echo ""

echo "PREPARING" > "%MINIFORGE_DIR%\..\.status"
set SCRIPTS_DIR=%MINIFORGE_DIR%\Scripts

if not exist %SCRIPTS_DIR% (
	echo "*** Installing Miniconda"
	mkdir %MINIFORGE_DIR%

	"%MINIFORGE_DIR%\..\miniforge.exe" /InstallationType=JustMe /RegisterPython=0 /S /D=%MINIFORGE_DIR%

	del "%MINIFORGE_DIR%\..\miniforge.exe" /s /q
	echo "*** Miniconda Installation Complete"
) else (
	echo "*** Miniforge is Already Installed"
)

if not exist %ENV_DIR% (
	REM Create and activate environment
	if exist %MINIFORGE_DIR%\..\..\environment.yml (
		echo "call %SCRIPTS_DIR%\conda.exe env create -f %MINIFORGE_DIR%\..\..\environment.yml --prefix=%ENV_DIR%"
		%SCRIPTS_DIR%\conda.exe env create -f %MINIFORGE_DIR%\..\..\environment.yml --prefix=%ENV_DIR%
	) else (
		echo ERROR: environment.yml does not exist
	)

	REM Workaround for: module 'jwt.exceptions' has no attribute 'DecodeError'.
	%SCRIPTS_DIR%\conda.exe run -n %ENV_NAME% pip install jwt --no-input
	%SCRIPTS_DIR%\conda.exe run -n %ENV_NAME% pip uninstall jwt --yes
	%SCRIPTS_DIR%\conda.exe run -n %ENV_NAME% pip uninstall PyJWT --yes
    %SCRIPTS_DIR%\conda.exe run -n %ENV_NAME% pip install PyJWT --no-input

	REM Clean up
	del "%MINIFORGE_DIR%\..\.status"
	echo "*** Setup Complete"
) else (
	echo ERROR: Environment %env_name% already exists.
	exit /b 0
)

GOTO :EOF

endlocal 